/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.NightVisionPower;
import io.github.apace100.origins.power.PhasingPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.ShaderPower;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private ActiveRenderInfo field_215317_L;
    @Shadow
    @Final
    private Minecraft field_78531_r;
    @Shadow
    private ItemStack field_190566_ab;
    @Shadow
    private ShaderGroup field_147707_d;
    @Shadow
    private boolean field_175083_ad;
    @Unique
    private ResourceLocation currentlyLoadedShader;
    private HashMap<BlockPos, BlockState> savedStates = new HashMap();

    @Shadow
    protected abstract void func_243497_c(float var1);

    @Shadow
    protected abstract void func_175069_a(ResourceLocation var1);

    @Inject(at={@At(value="TAIL")}, method={"onCameraEntitySet"})
    private void loadShaderFromPowerOnCameraEntity(Entity entity, CallbackInfo ci) {
        OriginComponent.withPower(this.field_78531_r.func_175606_aa(), ShaderPower.class, null, shaderPower -> {
            ResourceLocation shaderLoc = shaderPower.getShaderLocation();
            this.func_175069_a(shaderLoc);
            this.currentlyLoadedShader = shaderLoc;
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void loadShaderFromPower(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        OriginComponent.withPower(this.field_78531_r.func_175606_aa(), ShaderPower.class, null, shaderPower -> {
            ResourceLocation shaderLoc = shaderPower.getShaderLocation();
            if (this.currentlyLoadedShader != shaderLoc) {
                this.func_175069_a(shaderLoc);
                this.currentlyLoadedShader = shaderLoc;
            }
        });
        if (!OriginComponent.hasPower(this.field_78531_r.func_175606_aa(), ShaderPower.class) && this.currentlyLoadedShader != null) {
            this.field_147707_d.close();
            this.field_147707_d = null;
            this.field_175083_ad = false;
            this.currentlyLoadedShader = null;
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;getFramebuffer()Lnet/minecraft/client/gl/Framebuffer;")}, method={"render"})
    private void fixHudWithShaderEnabled(float tickDelta, long nanoTime, boolean renderLevel, CallbackInfo info) {
        RenderSystem.enableTexture();
    }

    @Inject(at={@At(value="HEAD")}, method={"getNightVisionStrength"}, cancellable=true)
    private static void getNightVisionStrength(LivingEntity livingEntity, float f, CallbackInfoReturnable<Float> info) {
        if (livingEntity instanceof PlayerEntity && !livingEntity.func_70644_a(Effects.field_76439_r)) {
            List<NightVisionPower> nvs = ModComponentsArchitectury.getOriginComponent((Entity)livingEntity).getPowers(NightVisionPower.class);
            Optional<Float> strength = nvs.stream().filter(Power::isActive).map(NightVisionPower::getStrength).max(Float::compareTo);
            strength.ifPresent(arg_0 -> info.setReturnValue(arg_0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void beforeRender(float tickDelta, long startTime, boolean tick, CallbackInfo info) {
        block5: {
            block4: {
                List<PhasingPower> phasings = OriginComponent.getPowers(this.field_215317_L.func_216773_g(), PhasingPower.class);
                if (!phasings.stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.REMOVE_BLOCKS)) break block4;
                Set<BlockPos> eyePositions = this.getEyePos(0.25f, 0.05f, 0.25f);
                HashSet<BlockPos> noLongerEyePositions = new HashSet<BlockPos>();
                for (BlockPos p : this.savedStates.keySet()) {
                    if (eyePositions.contains(p)) continue;
                    noLongerEyePositions.add(p);
                }
                for (BlockPos eyePosition : noLongerEyePositions) {
                    BlockState state = this.savedStates.get(eyePosition);
                    this.field_78531_r.field_71441_e.func_175656_a(eyePosition, state);
                    this.savedStates.remove(eyePosition);
                }
                for (BlockPos p : eyePositions) {
                    BlockState stateAtP = this.field_78531_r.field_71441_e.func_180495_p(p);
                    if (this.savedStates.containsKey(p) || this.field_78531_r.field_71441_e.func_175623_d(p) || stateAtP.func_177230_c() instanceof FlowingFluidBlock) continue;
                    this.savedStates.put(p, stateAtP);
                    this.field_78531_r.field_71441_e.func_195597_b(p, Blocks.field_150350_a.func_176223_P());
                }
                break block5;
            }
            if (this.savedStates.size() <= 0) break block5;
            HashSet<BlockPos> noLongerEyePositions = new HashSet<BlockPos>(this.savedStates.keySet());
            for (BlockPos eyePosition : noLongerEyePositions) {
                BlockState state = this.savedStates.get(eyePosition);
                this.field_78531_r.field_71441_e.func_175656_a(eyePosition, state);
                this.savedStates.remove(eyePosition);
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V"), method={"renderWorld"})
    private void preventThirdPerson(ActiveRenderInfo camera, IBlockReader area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta) {
        if (OriginComponent.getPowers(camera.func_216773_g(), PhasingPower.class).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.REMOVE_BLOCKS)) {
            camera.func_216772_a(area, focusedEntity, false, false, tickDelta);
        } else {
            camera.func_216772_a(area, focusedEntity, thirdPerson, inverseView, tickDelta);
        }
    }

    private Set<BlockPos> getEyePos(float rangeX, float rangeY, float rangeZ) {
        Vector3d pos = this.field_215317_L.func_216773_g().func_213303_ch().func_72441_c(0.0, (double)this.field_215317_L.func_216773_g().func_213307_e(this.field_215317_L.func_216773_g().func_213283_Z()), 0.0);
        AxisAlignedBB cameraBox = new AxisAlignedBB(pos, pos);
        cameraBox = cameraBox.func_72314_b((double)rangeX, (double)rangeY, (double)rangeZ);
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        BlockPos.func_239581_a_((AxisAlignedBB)cameraBox).forEach(p -> set.add(p.func_185334_h()));
        return set;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;lerp(FFF)F")})
    private void drawPhantomizedOverlay(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        if (OriginComponent.getPowers((Entity)this.field_78531_r.field_71439_g, PhasingPower.class).size() > 0 && !this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k)) {
            this.func_243497_c(OriginsClient.config.phantomizedOverlayStrength);
        }
    }
}

